<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment;

trait TraitPostCommentGetters
{
    use TraitPostCommentProperties;

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getParentPostId(): string
    {
        return $this -> parentPostId;
    }

    public function getOwnerUserId(): string
    {
        return $this -> ownerUserId;
    }

    public function getReplyToPostCommentId(): string
    {
        return $this -> replyToPostCommentId;
    }

    public function getDisplayText(): string
    {
        return $this -> displayText;
    }

    public function getCacheLikesCount(): string
    {
        return $this -> cacheLikesCount;
    }

    public function getCacheCommentsCount(): string
    {
        return $this -> cacheCommentsCount;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
